/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.mods.scrollabletooltips;

import club.sk1er.mods.scrollabletooltips.Config;
import gg.essential.universal.UKeyboard;
import gg.essential.universal.UMatrixStack;
import java.util.List;
import org.lwjgl.input.Mouse;

public class GuiUtilsOverride {
    public static int scrollY = 0;
    public static boolean allowScrolling;
    public static int scrollX;
    public static double zoomFactor;

    public static void drawHoveringText(UMatrixStack matrixStack, List<String> textLines, int screenHeight, int tooltipY, int tooltipHeight) {
        if (!allowScrolling) {
            scrollX = 0;
            scrollY = tooltipY < 0 && Config.startAtTop ? -tooltipY + 6 : 0;
            zoomFactor = 1.0;
        }
        if (!Config.masterToggle) {
            return;
        }
        boolean bl = allowScrolling = tooltipY < 0;
        if (allowScrolling) {
            int eventDWheel = Mouse.getDWheel();
            if (UKeyboard.isCtrlKeyDown() && Config.zoom) {
                zoomFactor *= 1.0 + 0.1 * (double)Integer.signum(eventDWheel);
            } else if (UKeyboard.isShiftKeyDown() && Config.horizontalScrolling) {
                if (eventDWheel < 0) {
                    scrollX += 10;
                } else if (eventDWheel > 0) {
                    scrollX -= 10;
                }
            } else if (Config.verticalScrolling) {
                if (eventDWheel < 0) {
                    scrollY -= 10;
                } else if (eventDWheel > 0) {
                    scrollY += 10;
                }
            }
            if (scrollY + tooltipY > 6) {
                scrollY = -tooltipY + 6;
            } else if (scrollY + tooltipY + tooltipHeight + 6 < screenHeight) {
                scrollY = screenHeight - 6 - tooltipY - tooltipHeight;
            }
        }
        matrixStack.translate(scrollX, scrollY, 0.0f);
        matrixStack.scale(zoomFactor, zoomFactor, 0.0);
        matrixStack.applyToGlobalState();
    }

    static {
        scrollX = 0;
        zoomFactor = 1.0;
    }
}

